unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  StdCtrls, FileCtrl,ExtCtrls, Buttons, ComCtrls, BTFF;

type 
  TForm1 = class(TForm)
    ListView: TListView;
    Panel1: TPanel;
    mmoFolders: TMemo;
    mmoFiles: TMemo;
    mmoExtensions: TMemo;
    mmoIndividuals: TMemo;
    gboSearchMode: TRadioGroup;
    gboCriteria: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    chFileName: TCheckBox;
    chExtension: TCheckBox;
    chSubFoldersToo: TCheckBox;
    chNewerThan: TCheckBox;
    chOlderThan: TCheckBox;
    chLargerThan: TCheckBox;
    chSmallerThan: TCheckBox;
    dtpNewerThan: TDateTimePicker;
    dtpOlderThan: TDateTimePicker;
    udLargerThan: TUpDown;
    udSmallerThan: TUpDown;
    edtLargerThan: TEdit;
    edtSmallerThan: TEdit;
    Edit1: TEdit;
    Edit2: TEdit;
    btnSearch: TBitBtn;
    btnStop: TBitBtn;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    lblSearchedFolders: TLabel;
    lblSearchedFiles: TLabel;
    lblFoundFiles: TLabel;
    lblTotalFoundSize: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ListViewColumnClick(Sender: TObject; Column: TListColumn);
    procedure ListViewCompare(Sender: TObject; Item1, Item2: TListItem; Data: Integer; var Compare: Integer);
    procedure ListViewDblClick(Sender: TObject);
    procedure AnyUpDownClick(Sender: TObject; Button: TUDBtnType);
    procedure btnSearchClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
   SortBy   : integer;
   FF       : TBTFileFinder;
   FileList : TStringList;
   procedure AddToListView;
   procedure SearchForFiles;
  end;

var
  Form1: TForm1;




implementation

{$R *.DFM}

uses
  ShellApi;

const
  FILENAME_ID         = 0;
  FOLDER_ID           = 1;
  SIZE_ID             = 2;
  FILETYPE_ID         = 3;
  CREATION_TIME_ID    = 4;
  LAST_WRITE_TIME_ID  = 5;
  LAST_ACCESS_TIME_ID = 6;


{----------------------------------------------------------------------------------
 Description    : fills up the List parameter with any file found having
                  Path, FileName and Ext matching.
 Error checking : NO
 Notes          : 1. Searches only the directory specified in Path, not the sub directories
                  2. It collects only plain files, directories excluded
                  3. Wildcards such as * and ? are acceptable
-----------------------------------------------------------------------------------}
procedure FileFind(Path, FileName, Ext:string; List:TStrings);
var
  SearchRec: TSearchRec;
  FindResult : Integer;
  S : string;
begin
  S := Path + '\' + FileName + '.' + Ext;
  FindResult := FindFirst(S, faAnyFile, SearchRec);
  while FindResult = 0 do
  begin
    if ((SearchRec.Name <> '.') and (SearchRec.Name <> '..'))
    then
      if not ((SearchRec.Attr and faDirectory) > 0)
      then List.Add(Path + '\' +SearchRec.Name);
    //List.Add(Path + '\' +SearchRec.Name);
    FindResult := FindNext(SearchRec);
  end;
  SysUtils.FindClose(SearchRec);
end;


{---------------------------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
var
 S   : string;
 SFI : TSHFileInfo;
begin

  FF := TBTFileFinder.Create;
  FileList := TStringList.Create;


  dtpNewerThan.Date := FileDateToDateTime(FileAge( Application.ExeName));
  dtpOlderThan.Date := FileDateToDateTime(FileAge( 'C:\Autoexec.bat' ));


  edtLargerThan.Text :=  Format('%f', [( udLargerThan.Position * KBYTE ) / MBYTE]);
  edtSmallerThan.Text := Format('%f', [( udSmallerThan.Position * KBYTE) / MBYTE]);

  S := ExtractFilePath(Application.ExeName);
  SetLength(S , Length(S) -1 );

  mmoFolders.Text := S ;
  mmoFiles.Text := '*';
  mmoExtensions.Text := '*';
  mmoIndividuals.Clear;
  //FileFind(S, '*', '*', mmoIndividuals.Lines);
  FileFind('C:', '*', '*', mmoIndividuals.Lines);

  { connect the system image list to the ListView }
  with ListView do
  begin
    SmallImages := TImageList.CreateSize(16,16);
    SmallImages.ShareImages := True;
    SmallImages.Handle := ShGetFileInfo('*.*',
                                         0,
                                         SFI,
                                         SizeOf(SFI),
                                         SHGFI_SMALLICON or SHGFI_ICON or SHGFI_SYSICONINDEX);
      
    LargeImages := TImageList.Create(nil);
    LargeImages.ShareImages := True;
    LargeImages.Handle := ShGetFileInfo('*.*',
                                         0,
                                         SFI,
                                         SizeOf(SFI),
                                         SHGFI_LARGEICON or SHGFI_ICON or SHGFI_SYSICONINDEX);
      
  end;
end;


{---------------------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 ListView.SmallImages.Free;
 ListView.LargeImages.Free;
 FF.Free;
 FileList.Free;
end;


{---------------------------------------------------------------------------------}
function Get_FileTypeAndIconIndex(FileName:string; var FileType: string ):integer;
var
  Ext : string;
  SFI : TSHFileInfo;
begin
  Ext := FileName;
  ShGetFileInfo(PChar(Ext),
                0,
                SFI,
                SizeOf(SFI),
                SHGFI_SMALLICON or  SHGFI_SYSICONINDEX or SHGFI_TYPENAME);
  FileType := String(SFI.szTypeName);
  Result   := SFI.iIcon;
end;


{---------------------------------------------------------------------------------}
procedure TForm1.AddToListView;
var
  i              : integer;
  FileName       : string;
  Folder         : string;
  Size           : string;
  FileType       : string;
  CreationTime   : string;
  LastAccessTime : string;
  LastWriteTime  : string;
  ListItem       : TListItem;
  S              : string;
begin        

  for i := 0 to FileList.Count - 1 do
  begin
    ParseFileInfoString(FileList[i], FileName, Folder, Size, S,  CreationTime, LastAccessTime, LastWriteTime);
    with ListView do
    begin
      ListItem := Items.Add;
      ListItem.ImageIndex := Get_FileTypeAndIconIndex(Folder + '\' + FileName, FileType);
      ListItem.Caption := FileName;
      ListItem.SubItems.Add(Folder);
      ListItem.SubItems.Add(Size);
      ListItem.SubItems.Add(FileType);
      ListItem.SubItems.Add(CreationTime);
      ListItem.SubItems.Add(LastWriteTime);
      ListItem.SubItems.Add(LastAccessTime);
    end;
  end;
  ListView.UpdateItems(0, ListView.Items.Count - 1);
end;


{---------------------------------------------------------------------------------}
procedure TForm1.SearchForFiles;
begin

  ListView.Items.Clear;

  { smAll, smSelected, smCriteria }
  FF.SearchMode     := TSearchMode(gboSearchMode.ItemIndex);

  { scFileName, scExtension, scSubFoldersToo, scNewerThan, scOlderThan, scLargerThan, scSmallerThan }
  FF.SearchCriteria := [];
  if chFileName.Checked then FF.SearchCriteria := FF.SearchCriteria + [scFileName];
  if chExtension.Checked then FF.SearchCriteria := FF.SearchCriteria + [scExtension];
  if chSubFoldersToo.Checked then FF.SearchCriteria := FF.SearchCriteria + [scSubFoldersToo];
  if chNewerThan.Checked then FF.SearchCriteria := FF.SearchCriteria + [scNewerThan];
  if chOlderThan.Checked then FF.SearchCriteria := FF.SearchCriteria + [scOlderThan];
  if chLargerThan.Checked then FF.SearchCriteria := FF.SearchCriteria + [scLargerThan];
  if chSmallerThan.Checked then FF.SearchCriteria := FF.SearchCriteria + [scSmallerThan];

  FF.NewerThan      := DateTimeToFileDate(dtpNewerThan.Date) ;
  FF.OlderThan      := DateTimeToFileDate(dtpOlderThan.Date) ;
  FF.LargerThan     := udLargerThan.Position ;
  FF.SmallerThan    := udSmallerThan.Position ;
  
  FF.IndividualFilesList.AddStrings(mmoIndividuals.Lines);
  FF.FoldersList.AddStrings(mmoFolders.Lines);
  FF.ChosenFilesList.AddStrings(mmoFiles.Lines);
  FF.ChosenExtList.AddStrings(mmoExtensions.Lines);
  FF.Execute;


  FileList.Clear;
  FileList.AddStrings(FF.ResultFileList);
end;


{---------------------------------------------------------------------------------}
procedure TForm1.ListViewColumnClick(Sender: TObject; Column: TListColumn);
begin
  SortBy := Column.ID;
  ListView.AlphaSort;
end;


{---------------------------------------------------------------------------------}
procedure TForm1.ListViewCompare(Sender: TObject; Item1, Item2: TListItem; Data: Integer; var Compare: Integer);
var
 S1,
 S2 : string;
 I1,
 I2 :integer;
begin

  case SortBy of
    FILENAME_ID         : begin S1 := Item1.Caption; S2 := Item2.Caption;  end;
    SIZE_ID             : begin
                            S1 := Item1.SubItems[SortBy - 1];
                            S2 := Item2.SubItems[SortBy - 1];
                            S1 := StringOfChar('0', 15) + S1;
                            S2 := StringOfChar('0', 15) + S2;
                            S1 := Copy(S1, Length(S1) - 15, 16);
                            S2 := Copy(S2, Length(S2) - 15, 16);
                           end;
    FOLDER_ID           ,
    FILETYPE_ID         : begin S1 := Item1.SubItems[SortBy - 1]; S2 := Item2.SubItems[SortBy - 1];  end;
    CREATION_TIME_ID    ,
    LAST_WRITE_TIME_ID  ,
    LAST_ACCESS_TIME_ID : begin
                            I1 := DateTimeToFileDate(StrToDateTime(Item1.SubItems[SortBy - 1]));
                            I2 := DateTimeToFileDate(StrToDateTime(Item2.SubItems[SortBy - 1]));
                          end;
  end;


  if SortBy < CREATION_TIME_ID
  then
    begin
      if S1 = S2 then Compare := 0;
      if S1 < S2 then Compare := -1;
      if S1 > S2 then Compare := 1;
    end
  else
    begin
      if I1 = I2 then Compare := 0;
      if I1 > I2 then Compare := -1;
      if I1 < I2 then Compare := 1;
    end;
  
end;


{---------------------------------------------------------------------------------}
procedure TForm1.ListViewDblClick(Sender: TObject);
var
 S : string;
begin
  if ListView.Items.Count > 0
  then
    with ListView do
    begin
      S := Items[Selected.Index].SubItems[0] + '\' + Items[Selected.Index].Caption;
      ShellExecute( Handle,               { hWnd: HWND        }
                    'open',               { Operation: PChar  }
                    PChar(S),             { FileName: PChar   }
                    '',                   { Parameters: PChar }
                    '',                   { Directory: PChar  }
                    SW_SHOW );            { ShowCmd: Integer  }

    end;
end;


{---------------------------------------------------------------------------------}
procedure TForm1.AnyUpDownClick(Sender: TObject; Button: TUDBtnType);
begin
  edtLargerThan.Text :=  Format('%f', [( udLargerThan.Position * KBYTE ) / MBYTE]);
  edtSmallerThan.Text := Format('%f', [( udSmallerThan.Position * KBYTE) / MBYTE]);   
end;


{---------------------------------------------------------------------------------}
procedure TForm1.btnSearchClick(Sender: TObject);
begin

  btnStop.Enabled   := True;
  btnSearch.Enabled := False;

  try
    ListView.SortType := stNone;
    SearchForFiles;
    AddToListView;
    ListView.SortType := stText;
    SortBy := FILENAME_ID;
    ListView.AlphaSort;
  finally
    btnStop.Enabled   := False;
    btnSearch.Enabled := True;
    lblSearchedFolders.Caption := 'Searched Folders :'  +  IntToStr(FF.SearchedFolders ) ;
    lblSearchedFiles.Caption   := 'Searched Files   :' + IntToStr(FF.SearchedFiles ) ;
    lblFoundFiles.Caption      := 'Found Files      :' + IntToStr(FF.ResultFileList.Count ) ;
    lblTotalFoundSize.Caption  := Format('Total FoundSize  :%f MB', [FF.TotalFoundSize / MBYTE]);   
    FF.ClearLists;
  end;
end;


{---------------------------------------------------------------------------------}
procedure TForm1.btnStopClick(Sender: TObject);
begin
  FF.Stop;      
end;

end.



















































